
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    double      p;
    int         i, m, len, order;
    string      inString;
    char        *xString;
    poly        x; // holds primitive poly
    poly        *z; // holds poly cyclic group
    
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >>m;
    }
    
    cin.ignore();  // needed for next cin with prompt to behave
    
    cout << "poly: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
    
    if(!polyConvFromxString(x, xString))
    {
        cout << "bad input" << endl << endl;
        goto again;
    }
    
    free(xString);
    
    genPolyCyclicGroup(z, x, m, p);
    order = pow(p, m) - 1;
    for(i=0;i<order;++i)
    {
        polyConvToxString(xString, z[i]);
        cout << xString << endl;
        free(xString);
    }
    
    return 0;
}

